/**
 * 蓝牙麻将键盘
 */
#include <BleKeyboard.h>     //蓝牙键盘库
#include "Adafruit_Keypad.h"            //键盘阵列库

BleKeyboard bleKeyboard("mahjong_bt_kbd");   //自定义蓝牙名称

const byte ROWS = 4;      //定义行数
const byte COLS = 5;      //定义列数
//初始化键盘阵列
byte keys[ROWS][COLS] = {
  { 1, 2, 3, 4, 5 },
  { 6, 7, 8, 9, 10 },
  { 11, 12, 13, 14, 15 },
  { 16, 17, 18, 19, 20 }
};
byte rowPins[ROWS] = { 5,17,16,4 };    //行引脚
byte colPins[COLS] = { 23,22,21,2,15 };  //列引脚

Adafruit_Keypad customKeypad = Adafruit_Keypad(makeKeymap(keys), rowPins, colPins, ROWS, COLS);


void setup() {
  bleKeyboard.begin();
  customKeypad.begin();
}

void loop() {
  customKeypad.tick();
  if (bleKeyboard.isConnected()) {
    while (customKeypad.available()) {
      keypadEvent e = customKeypad.read();
      if (e.bit.EVENT == KEY_JUST_RELEASED) {
        switch ((int)e.bit.KEY) {
          case 1:
            bleKeyboard.press(KEY_LEFT_CTRL);
            break;
          case 2:
            bleKeyboard.press(KEY_LEFT_ALT);
            break;
          case 3:
            bleKeyboard.press(' ');
            break;
          case 4:
            bleKeyboard.press(KEY_LEFT_SHIFT);
            break;
          case 5:
            bleKeyboard.press('z');
            break;
          case 6:
            bleKeyboard.press('a');
            break;
          case 7:
            bleKeyboard.press('b');
            break;
          case 8:
            bleKeyboard.press('c');
            break;
          case 9:
            bleKeyboard.press('d');
            break;
          case 10:
            bleKeyboard.press('e');
            break;
          case 11:
            bleKeyboard.press('f');
            break;
          case 12:
            bleKeyboard.press('g');
            break;
          case 13:
            bleKeyboard.press('h');
            break;
          case 14:
            bleKeyboard.press('i');
            break;
          case 15:
            bleKeyboard.press('j');
            break;
          case 16:
            bleKeyboard.press('k');
            break;
          case 17:
            bleKeyboard.press('l');
            break;
          case 18:
            bleKeyboard.press('m');
            break;
          case 19:
            bleKeyboard.press('y');
            break;
          case 20:
            bleKeyboard.press('n');
            break;
        }
        delay(100);
        bleKeyboard.releaseAll();
      }
    }
  }
}
